/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.wizards;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.projects.primary.natures.IPrimaryNatureContributor;
import com.aptana.projects.primary.natures.PrimaryNaturesManager;
import com.aptana.ui.epl.UIEplPlugin;
import com.aptana.ui.properties.NaturesLabelProvider;
import com.aptana.ui.wizards.EplMessages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class WizardFolderImportPage
extends WizardPage
implements IOverwriteQuery,
ICheckStateListener,
SelectionListener {
    private static final String APTANA_WEB_NATURE = "com.aptana.projects.webnature";
    private Text directoryPathField;
    private Text projectNameField;
    private String directoryPath;
    private ModifyListener modifyListener;
    private HashSet<String> projectsNames;
    private Button fMakePrimaryButton;
    private MenuItem fSetPrimaryMenuItem;
    private NaturesLabelProvider fLabelProvider;
    private CheckboxTableViewer fTableViewer;
    private String fPrimaryNature;
    private Map<String, String> fNatureDescriptions;
    private static String previouslyBrowsedDirectory = "";
    private Button browseDirectoriesButton;
    private Map<String, IPrimaryNatureContributor> natureContributors = new HashMap<String, IPrimaryNatureContributor>();

    public WizardFolderImportPage() {
        this("wizardExternalProjectsPage");
    }

    public WizardFolderImportPage(String pageName) {
        this(pageName, EplMessages.WizardFolderImportPage_ExistingFolderAsNewProject, null);
    }

    public WizardFolderImportPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setPageComplete(false);
        this.fNatureDescriptions = new HashMap<String, String>();
    }

    private void setPrimaryNatureFromContributions(IPath projectPath) {
        int highestPrimaryNatureRank = -1;
        String potentialPrimaryNature = null;
        for (String natureId : this.natureContributors.keySet()) {
            IPrimaryNatureContributor primaryNatureContributor = this.natureContributors.get(natureId);
            int primaryNatureRank = primaryNatureContributor.getPrimaryNatureRank(projectPath);
            if (primaryNatureRank <= highestPrimaryNatureRank) continue;
            potentialPrimaryNature = natureId;
            highestPrimaryNatureRank = primaryNatureRank;
        }
        if (StringUtil.isEmpty(potentialPrimaryNature)) {
            this.updatePrimaryNature(APTANA_WEB_NATURE);
        } else {
            this.updatePrimaryNature(potentialPrimaryNature);
        }
    }

    public void createControl(Composite parent) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.projectsNames = new HashSet();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.projectsNames.add(project.getName());
            ++n2;
        }
        this.modifyListener = new InputModifyListener();
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        Dialog.applyDialogFont((Control)workArea);
        this.fLabelProvider = new NaturesLabelProvider(this.fNatureDescriptions);
        Label l = new Label(workArea, 0);
        l.setText(EplMessages.WizardFolderImportPage_project_type_title);
        this.natureContributors = PrimaryNaturesManager.getManager().getContributorsMap();
        Composite tableComposite = new Composite(workArea, 0);
        tableComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        tableComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)2176);
        Table table = this.fTableViewer.getTable();
        table.setLinesVisible(true);
        table.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        TableColumn column = new TableColumn(table, 16384);
        column.setWidth(350);
        this.fTableViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fTableViewer.setComparator(this.getViewerComperator());
        this.fTableViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.fTableViewer.addCheckStateListener((ICheckStateListener)this);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WizardFolderImportPage.this.updateButtons();
            }
        });
        table.setMenu(this.createMenu(table));
        Composite buttons = new Composite(tableComposite, 0);
        buttons.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        buttons.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        this.fMakePrimaryButton = this.createButton(EplMessages.WizardFolderImportPage_make_primary_label, buttons);
        this.updateButtons();
        this.setPageComplete(false);
        this.setPrimaryNatureFromContributions(null);
        this.fTableViewer.setCheckedElements((Object[])new String[]{this.fPrimaryNature});
        if (!StringUtil.isEmpty((String)this.directoryPath)) {
            this.directoryPathField.setText(this.directoryPath);
            this.setProjectName();
            this.setPageComplete(true);
        }
    }

    private void createProjectsRoot(Composite workArea) {
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label l = new Label(projectGroup, 0);
        l.setText(EplMessages.WizardFolderImportPage_SelectFolder);
        this.directoryPathField = new Text(projectGroup, 2048);
        this.directoryPathField.addModifyListener(this.modifyListener);
        this.directoryPathField.setLayoutData((Object)new GridData(768));
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText(DataTransferMessages.DataTransfer_browse);
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFolderImportPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        l = new Label(projectGroup, 0);
        l.setText(EplMessages.WizardFolderImportPage_ProjectName);
        this.projectNameField = new Text(projectGroup, 2048);
        this.projectNameField.addModifyListener(this.modifyListener);
        this.projectNameField.setLayoutData((Object)new GridData(768));
    }

    /*
     * Unable to fully structure code
     */
    protected boolean validate() {
        if (this.directoryPathField.getText().trim().length() == 0) {
            this.setErrorMessage(EplMessages.WizardFolderImportPage_ERR_NoFolderSelected);
            return false;
        }
        if (!new File(this.directoryPathField.getText()).exists()) {
            this.setErrorMessage(EplMessages.WizardFolderImportPage_ERR_FolderNotExist);
            return false;
        }
        name = this.projectNameField.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage(EplMessages.WizardFolderImportPage_ERR_NoProjectName);
            return false;
        }
        if (this.projectsNames.contains(name)) {
            this.setErrorMessage(EplMessages.WizardFolderImportPage_ERR_ProjectNameExists);
            return false;
        }
        path = Path.fromOSString((String)this.directoryPathField.getText());
        this.setPrimaryNatureFromContributions(path);
        dotProjectPath = path.append(".project");
        description = null;
        if (dotProjectPath.toFile().exists()) {
            try {
                description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription(dotProjectPath);
                if (description == null || description.getNatureIds().length <= 0) ** GOTO lbl54
                delimiter = "";
                natures = new StringBuilder();
                var10_9 = description.getNatureIds();
                var9_10 = var10_9.length;
                var8_11 = 0;
                while (var8_11 < var9_10) {
                    natureId = var10_9[var8_11];
                    nature = this.fLabelProvider.getText(natureId);
                    if (StringUtil.isEmpty((String)nature)) {
                        nature = natureId;
                    }
                    natures.append(delimiter).append(nature);
                    delimiter = ", ";
                    ++var8_11;
                }
                natureIds = description.getNatureIds();
                if (natureIds.length > 0 && !natureIds[0].equals(this.fPrimaryNature)) {
                    oldNatures = natureIds;
                    natureIds = new String[description.getNatureIds().length + 1];
                    System.arraycopy(oldNatures, 0, natureIds, 1, oldNatures.length);
                    natureIds[0] = this.fPrimaryNature;
                }
                this.fTableViewer.setCheckedElements(natureIds);
                this.setMessage(String.valueOf(EplMessages.WizardFolderImportPage_override_project_nature) + natures.toString(), 2);
                this.setErrorMessage(null);
                return true;
            }
            catch (CoreException e) {
                IdeLog.logWarning((Plugin)UIEplPlugin.getDefault(), (String)("Error reading project description for " + name), (Throwable)e);
            }
        } else {
            potentialNatures = PrimaryNaturesManager.getManager().getPotentialNaturesFromPath(path);
            potentialNatures.add("com.aptana.projects.webnature");
            this.fTableViewer.setCheckedElements((Object[])potentialNatures.toArray(new String[potentialNatures.size()]));
        }
lbl54:
        // 3 sources

        this.setMessage(null);
        this.setErrorMessage(null);
        return true;
    }

    protected void displayErrorDialog(String message) {
        MessageDialog.openError((Shell)this.getContainer().getShell(), (String)this.getErrorDialogTitle(), (String)message);
    }

    protected String getErrorDialogTitle() {
        return IDEWorkbenchMessages.WizardExportPage_internalErrorTitle;
    }

    protected void handleLocationDirectoryButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.directoryPathField.getShell());
        dialog.setMessage(DataTransferMessages.WizardProjectsImportPage_SelectDialogTitle);
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
        }
        this.setProjectName();
        this.setPageComplete(this.directoryPathField.getText() != null);
    }

    private void setProjectName() {
        Path path;
        String text = this.directoryPathField.getText();
        if (!StringUtil.isEmpty((String)text) && (path = new Path(text)).segmentCount() > 0) {
            this.projectNameField.setText(path.lastSegment());
        }
    }

    public IProject createProject() {
        String projectPath = this.directoryPathField.getText();
        File projectFile = new File(projectPath);
        if (projectFile.exists()) {
            Object[] checkedNatures;
            ProjectRecord pr = new ProjectRecord(projectFile, this.projectNameField.getText());
            IProject project = this.createExistingProject(pr);
            Object[] objectArray = checkedNatures = this.fTableViewer.getCheckedElements();
            int n = checkedNatures.length;
            int n2 = 0;
            while (n2 < n) {
                Object natureId = objectArray[n2];
                IPrimaryNatureContributor contributor = this.natureContributors.get(natureId);
                if (contributor != null) {
                    try {
                        contributor.configure(project);
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)UIEplPlugin.getDefault(), (String)MessageFormat.format("Error configurating project ''{0}'' while importing it", project.getName()), (Throwable)e);
                    }
                }
                ++n2;
            }
            return project;
        }
        return null;
    }

    public boolean createProjects() {
        return this.createProject() != null;
    }

    private IProject createExistingProject(final ProjectRecord record) {
        Object[] checkedNatures = this.fTableViewer.getCheckedElements();
        ArrayList<String> natureIds = new ArrayList<String>();
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(projectName);
        if (record.description == null) {
            record.description = workspace.newProjectDescription(projectName);
            Path locationPath = new Path(record.projectSystemFile.getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                record.description.setLocation(null);
            } else {
                record.description.setLocation((IPath)locationPath);
            }
        } else {
            record.description.setName(projectName);
        }
        Object[] objectArray = checkedNatures;
        int n = checkedNatures.length;
        int n2 = 0;
        while (n2 < n) {
            Object nature = objectArray[n2];
            natureIds.add(nature.toString());
            ++n2;
        }
        if (this.fPrimaryNature != null) {
            natureIds.remove(this.fPrimaryNature);
            natureIds.add(0, this.fPrimaryNature);
        }
        if (natureIds.isEmpty()) {
            natureIds.add(0, APTANA_WEB_NATURE);
        }
        record.description.setNatureIds(natureIds.toArray(new String[natureIds.size()]));
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("", 2000);
                project.create(record.description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                project.setDescription(record.description, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (((CoreException)t).getStatus().getCode() == 275) {
                MessageDialog.openError((Shell)this.getShell(), (String)DataTransferMessages.WizardExternalProjectImportPage_errorMessage, (String)NLS.bind((String)DataTransferMessages.WizardExternalProjectImportPage_caseVariantExistsError, (Object)record.description.getName()));
            } else {
                ErrorDialog.openError((Shell)this.getShell(), (String)DataTransferMessages.WizardExternalProjectImportPage_errorMessage, (String)((CoreException)t).getLocalizedMessage(), (IStatus)((CoreException)t).getStatus());
            }
            return null;
        }
        try {
            WizardFolderImportPage.showView("com.aptana.ide.ui.io.fileExplorerView", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        BasicNewResourceWizard.selectAndReveal((IResource)project, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        return project;
    }

    protected boolean getFilesForProject(Collection files, IImportStructureProvider provider, Object entry) {
        List children = provider.getChildren(entry);
        for (Object child : children) {
            files.add(child);
            if (!provider.isFolder(child)) continue;
            this.getFilesForProject(files, provider, child);
        }
        return true;
    }

    protected boolean executeImportOperation(ImportOperation op) {
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.FileImport_importProblems, null, (IStatus)status);
            return false;
        }
        return true;
    }

    public String queryOverwrite(String pathString) {
        Path path = new Path(pathString);
        String messageString = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_existsQuestion, (Object)pathString) : NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), IDEWorkbenchMessages.Question, null, messageString, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
        if (this.directoryPathField != null && !StringUtil.isEmpty((String)directoryPath)) {
            this.directoryPathField.setText(directoryPath);
            this.setProjectName();
            this.setPageComplete(true);
        }
    }

    public static IViewPart showView(String viewId, IWorkbenchWindow window) throws PartInitException {
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            return page.showView(viewId);
        }
        return null;
    }

    private void updatePrimaryNature(String nature) {
        this.fPrimaryNature = nature;
        this.fLabelProvider.setPrimaryNature(this.fPrimaryNature);
        this.fTableViewer.refresh();
    }

    private IStructuredContentProvider getContentProvider() {
        return new BaseWorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                IProjectNatureDescriptor[] natureDescriptors;
                if (!(o instanceof IWorkspace)) {
                    return new Object[0];
                }
                HashSet<String> elements = new HashSet<String>();
                IProjectNatureDescriptor[] iProjectNatureDescriptorArray = natureDescriptors = ((IWorkspace)o).getNatureDescriptors();
                int n = natureDescriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    IProjectNatureDescriptor descriptor = iProjectNatureDescriptorArray[n2];
                    String natureId = descriptor.getNatureId();
                    if (natureId != null && ResourceUtil.isAptanaNature((String)natureId)) {
                        elements.add(natureId);
                        WizardFolderImportPage.this.fNatureDescriptions.put(natureId, descriptor.getLabel());
                    }
                    ++n2;
                }
                return elements.toArray();
            }
        };
    }

    private ILabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    private ViewerComparator getViewerComperator() {
        return new ViewerComparator((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (ResourceUtil.isAptanaNature((String)o1)) {
                    return ResourceUtil.isAptanaNature((String)o2) ? o1.compareTo(o2) : -1;
                }
                return ResourceUtil.isAptanaNature((String)o2) ? 1 : o1.compareTo(o2);
            }
        });
    }

    private Button createButton(String text, Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        button.addSelectionListener((SelectionListener)this);
        return button;
    }

    private void updateButtons() {
        StructuredSelection selection = (StructuredSelection)this.fTableViewer.getSelection();
        this.fMakePrimaryButton.setEnabled(!selection.isEmpty() && !this.isPrimary(selection.getFirstElement()));
    }

    protected boolean isPrimary(Object element) {
        return this.fPrimaryNature != null && this.fPrimaryNature.equals(element);
    }

    protected Menu createMenu(Table table) {
        Menu menu = new Menu((Control)table);
        this.fSetPrimaryMenuItem = new MenuItem(menu, 8);
        this.fSetPrimaryMenuItem.setText(EplMessages.WizardFolderImportPage_set_primary_label);
        this.fSetPrimaryMenuItem.addSelectionListener((SelectionListener)this);
        return menu;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object[] checkedElements = this.fTableViewer.getCheckedElements();
        if (this.fPrimaryNature == null) {
            if (event.getChecked()) {
                this.updatePrimaryNature(event.getElement().toString());
                this.fTableViewer.refresh();
            }
        } else if (!event.getChecked() && this.isPrimary(event.getElement())) {
            if (checkedElements.length == 0) {
                this.updatePrimaryNature(null);
            } else {
                this.updatePrimaryNature(checkedElements[0].toString());
            }
            this.fTableViewer.refresh();
        }
        this.updateButtons();
    }

    public void widgetSelected(SelectionEvent e) {
        ISelection selection;
        Object source = e.getSource();
        if ((source == this.fSetPrimaryMenuItem || source == this.fMakePrimaryButton) && !(selection = this.fTableViewer.getSelection()).isEmpty() && selection instanceof StructuredSelection) {
            Object firstElement = ((StructuredSelection)selection).getFirstElement();
            this.fTableViewer.setChecked(firstElement, true);
            this.updatePrimaryNature(firstElement.toString());
            this.fTableViewer.refresh();
            this.updateButtons();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private class InputModifyListener
    implements ModifyListener {
        private InputModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            WizardFolderImportPage.this.setPageComplete(WizardFolderImportPage.this.validate());
        }
    }

    private static class ProjectRecord {
        File projectSystemFile;
        Object projectArchiveFile;
        String projectName;
        Object parent;
        int level;
        IProjectDescription description;

        ProjectRecord(File file, String name) {
            this.projectSystemFile = file;
            this.setProjectName(name);
        }

        private void setProjectName(String name) {
            this.projectName = name;
        }

        public String getProjectName() {
            return this.projectName;
        }
    }
}

